%% CIS II Galen Kinematic Calibration 
%% Can Kocabalkanli, Spring 2020
%% Delta and Wrist trajectory generator

%% Trajectory for Delta
clear;
r = 100;
roll = 0;
tilt = 0;
points = [];
invKin = [];
%for z = -200:20:200
for z = 0:25:200 %0+10:20:200-10
    for y = -r:10:r %-r+7:14:r-7
        for x = -r:10:r %-r+7:14:r-7
            if x^2 + y^2 <= r^2
                %roll = rand()*pi/6-pi/12;
                %tilt = rand()*pi/6-pi/12;
                xyz = [x y z];
                %xyz_b = xyz + [666.925 0 597.251];
                xyz_b = xyz +  1000.*[0.66643 0 0.54083]%[0.66643 0 0.74083]
                points = [points; xyz_b(1) xyz_b(2) xyz_b(3)];
                invKin = [invKin; [0.001 0.001 0.001 1 1].*inverseKinematics(xyz_b(1), xyz_b(2), xyz_b(3), roll, tilt)'];
            end
        end
    end
    
end
csvwrite('delta_tool_mk2_3000.csv',invKin);
scatter3(points(:,1), points(:,2), points(:,3));
points = [];
hold on;
%% Test Trajectory generator (not needed, can modify above code instead)
for z = 0+12:25:200-12 %0+10:20:200-10 
    for y = -r+5:10:r-5 %-r+7:14:r-7
        for x = -r+5:10:r-5 %-r+7:14:r-7
            if x^2 + y^2 <= r^2
                %roll = rand()*pi/6-pi/12;
                %tilt = rand()*pi/6-pi/12;
                xyz = [x y z];
                %xyz_b = xyz + [666.925 0 597.251];
                xyz_b = xyz +  1000.*[0.66643 0 0.54083]%[0.66643 0 0.74083]
                points = [points; xyz_b(1) xyz_b(2) xyz_b(3)];
                invKin = [invKin; [0.001 0.001 0.001 1 1].*inverseKinematics(xyz_b(1), xyz_b(2), xyz_b(3), roll, tilt)'];
            end
        end
    end
    
end
scatter3(points(:,1), points(:,2), points(:,3));
csvwrite('delta_tool_mk2_3000_test.csv',invKin);

%% Trajectory for Wrist

wrist_centers = [0 0 0; 50 50 100];
invWrist = [];

for i = 1:size(wrist_centers)
    for phi = -pi/3+pi/20:pi/40:pi/3-pi/20%-pi/2+pi/20:pi/20:pi/2-pi/20
        for psi = -pi/3+pi/20:pi/40:pi/3-pi/20
            cen = wrist_centers(i,:) + 1000.*[0.66643 0 0.54083];
            in = inverseKinematics(cen(1), cen(2), cen(3), phi, psi)';
            invWrist = [invWrist; [in(1)/1000 in(2)/1000 in(3)/1000 phi psi]];
        end
    end
end

csvwrite('wrist_test_mk2_60_4.csv',invWrist);

    
    



